<?php
$version = '1.23';
$build = '01';
$description = '1.23';
$part = 'MAIN'; // CORE / TOOLS / HELP / THEMES

$autor = 'Sebastiaan Ebeltjes(NL) Andreas Scheibel(DE)';
$date = "2019.01.23";

$eccConfig = array(
	'ecc_release' => array(
		'title' => 'emuControlCenter',
		'title_short' => 'ecc',
		'local_release_version' => $version,
		'release_build' => $build,

		/*LIVE PACK*/
		'livepack_info_short' => $description,
		'livepack_software_part' => $part,
		'livepack_special_part' => '---',
		'livepack_part_version' => $version,
		'livepack_part_build' => $build,
		'livepack_part_date' => $date,
		'livepack_part_author' => $autor,
		/*END LIVE PACK*/

		'local_release_date' => $date,
		'release_state' => '',
		'website' => 'https://github.com/PhoenixInteractiveNL/emuControlCenter/wiki',
		'email' => 'phoenixinteractive@hotmail.com',
		'eccdat_version' => '1.2003',
		'eccdat_state' => '',
		'info_copyright' => '2005-2016 Sebastiaan Ebeltjes(NL) / Andreas Scheibel(DE)',
	),

	'user_path_subfolder_default' => array(
		'emus',
		'exports',
		'images',
		'videos',
		'roms',
		'utils',
		'assets',
	),

	'rom_path_subfolder' => array(
		'assets' => array(
		'manuals',
		'guides',
		'maps',
		'patches',
		),
	),

	'supported_images' => array(
		'jpg' => 1,
		'png' => 1,
		'gif' => 1,
		'bmp' => 1,
		'ico' => 1,
	),

	'cbox_yesno' => array(
		'*',
		'no',
		'no?',
		'yes',
		'ye?',
		'?',
	),

	'image_type' => array(
		'ingame_title' => 'Ingame - Title',
		'ingame_play_01' => 'Ingame - Play 1',
		'ingame_play_02' => 'Ingame - Play 2',
		'ingame_play_03' => 'Ingame - Play 3',
		'ingame_play_boss' => 'Ingame - Play final boss',
		'ingame_loading' => 'Ingame - Loading',

		'cover_front' => 'Cover-Art: Front',
		'cover_back' => 'Cover-Art: Back',
		'cover_spine' => 'Cover-Art: Spine',
		'cover_inlay_01' => 'Cover-Inlay 01',
		'cover_inlay_02' => 'Cover-Inlay 02',
		'cover_3d' => 'Cover-3D',

		'media_storage' => 'Storage: #1',
		'media_stor_02' => 'Storage: #2',
		'media_stor_03' => 'Storage: #3',
		'media_stor_04' => 'Storage: #4',
		'media_flyer' => 'Flyer #1',
		'media_flyer_02' => 'Flyer #2',
		'media_flyer_03' => 'Flyer #3',
		'media_flyer_04' => 'Flyer #4',
		'media_icon' => 'Icon',

		'booklet_page_01' => 'Booklet: Page 01',
		'booklet_page_02' => 'Booklet: Page 02',
		'booklet_page_03' => 'Booklet: Page 03',
		'booklet_page_04' => 'Booklet: Page 04',
		'booklet_page_05' => 'Booklet: Page 05',
		'booklet_page_06' => 'Booklet: Page 06',
		'booklet_page_07' => 'Booklet: Page 07',
		'booklet_page_08' => 'Booklet: Page 08',
		'booklet_page_09' => 'Booklet: Page 09',
		'booklet_page_10' => 'Booklet: Page 10',
	),

	'media_language' => array(
		'J' => '[[japanese]]',
		'E' => '[[english]]',
		'G' => '[[german]]',
		'F' => '[[french]]',
		'I' => '[[italian]]',
		'S' => '[[spanish]]',
		'C' => '[[chinese]]',
		'KOR' => '[[korean]]',
		'P' => '[[portugese]]',
		'PL' => '[[polish]]',
		'DK' => '[[danish]]',
		'NL' => '[[dutch]]',
		'NO' => '[[norway]]',
		'SW' => '[[swedish]]',
		'FN' => '[[finnish]]',
		'CS' => '[[czech]]',
		'HU' => '[[hungarian]]',
	),

	'media_category' => array(
		0 => "-",
		1 => "Arcade - Action",
		2 => "Adventure - [uncategorized]",
		3 => "Arcade - [uncategorized]",
		4 => "Arcade - Beat'em Up",
		5 => "Board Game - [uncategorized]",
		6 => "Cards - [uncategorized]",
		7 => "Gambling - Casino",
		8 => "Misc. - Compilation",
		9 => "Misc. - Demo",
		10 => "Misc. - Dictionary",
		11 => "Educational - [uncategorized]",
		12 => "Sports - Fighting",
		13 => "Sports - Fishing",
		14 => "Simulation - Flight",
		15 => "Shoot'em Up - FPS",
		16 => "Misc. - Hardware",
		17 => "Arcade - Hunting",
		18 => "Misc. - Intro",
		19 => "Brain - Logical Game",
		20 => "Board Game - Mahjong",
		21 => "Misc. - Mini Games",
		22 => "Misc. - Music ",
		23 => "Misc. - Party",
		24 => "Arcade - Pinball",
		25 => "Arcade - Jump n Run 2D",
		26 => "Brain - Puzzle",
		27 => "Racing - [uncategorized]",
		28 => "Adventure - RPG",
		29 => "Shoot'em Up - [uncategorized]",
		30 => "Shoot'em Up - Gun",
		31 => "Simulation - [uncategorized]",
		32 => "Gambling - Slot Machine",
		33 => "Sports - [uncategorized]",
		34 => "Strategy - [uncategorized]",
		35 => "Misc. - Tool",
		36 => "Misc. - Video",
		37 => "Misc. - XXX",
		38 => "Arcade - Breakout/Pong",
		39 => "Misc. - BIOS",
		40 => "Racing - Boat",
		41 => "Arcade - Labyrinth/Maze",
		42 => "Misc. - [uncategorized]",
		43 => "Gambling - Quiz",
		44 => "Misc. - Tabletop & Board",
		45 => "Unplayable",
		46 => "Sports - Billiard",
		47 => "Adventure - AdventureWriter/Quill",
		48 => "Sports - Baseball",
		49 => "Sports - Basketball",
		50 => "Sports - Bowling",
		51 => "Sports - Boxing",
		52 => "Sports - Darts",
		53 => "Sports - Dodgeball",
		54 => "Strategy - War",
		55 => "Sports - American Football",
		56 => "Sports - Football/Soccer",
		57 => "Sports - Rugby",
		58 => "Sports - Golf",
		59 => "Sports - Hockey",
		60 => "Sports - Riding",
		61 => "Sports - Snooker/Pool",
		62 => "Sports - Skateboarding",
		63 => "Sports - Skiing",
		64 => "Sports - Sumo",
		65 => "Sports - Swimming",
		66 => "Sports - Tennis",
		67 => "Sports - Track & Field",
		68 => "Sports - Volleyball",
		69 => "Sports - Wrestling",
		70 => "Adventure - Action Adventure",
		71 => "Simulation - Trading",
		72 => "Strategy - Trading",
		73 => "Shoot'em Up - FPS",
		74 => "Strategy - Wallstreet",
		75 => "Jump n Run 3D",
		76 => "Brain - [uncategorized]",
		77 => "Misc. - Emulator",
		78 => "Sports - Compilation",
		79 => "Brain - Moving blocks",
		80 => "- ??? Finger speed",
		81 => "Arcade - Platformer",
		82 => "Adventure - Action/RPG",
		83 => "Arcade - Pinball/Pachinko",
		84 => "Sports - Bike",
		85 => "Sports - Snowboarding",
		86 => "Sports - Multi-Event",
		87 => "Adventure - Arcade 2D",
		88 => "Adventure - Arcade 3D",
		89 => "Adventure - Click and Type",
		90 => "Adventure - Comic",
		91 => "Adventure - Construction Kit",
		92 => "Adventure - Graphic(Charset)/Text",
		93 => "Adventure - Graphic(Hi-Res)/Text",
		94 => "Adventure - Joystick only",
		95 => "Adventure - Miscellaneous",
		96 => "Adventure - Move and Type",
		97 => "Adventure - RPG 2D",
		98 => "Adventure - RPG 3D",
		99 => "Adventure - RPG Isometric",
		100 => "Adventure - RPG Text",
		101 => "Adventure - Selectable Answers",
		102 => "Adventure - Text only",
		103 => "Application - Astronomy",
		104 => "Application - Compile Tools",
		105 => "Application - Misc",
		106 => "Application - Music",
		107 => "Application - Paint",
		108 => "Application - Word Processing/Office",
		109 => "Arcade - Amidar",
		110 => "Arcade - Avoid it",
		111 => "Arcade - Bomberman",
		112 => "Arcade - Boulder Dash",
		113 => "Arcade - Catch it",
		114 => "Arcade - Challenge",
		115 => "Arcade - Collect'em Up",
		116 => "Arcade - Collect'em Up (Racing)",
		117 => "Arcade - Construction Kit",
		118 => "Arcade - Frogger",
		119 => "Arcade - Isometric",
		120 => "Arcade - Joust",
		121 => "Arcade - Lander",
		122 => "Arcade - Miscellaneous",
		123 => "Arcade - Multigenre",
		124 => "Arcade - Pac Man",
		125 => "Arcade - Pengo",
		126 => "Arcade - Platformer (3D)",
		127 => "Arcade - Platformer (Multi Screen)",
		128 => "Arcade - Platformer (Scrolling Screen)",
		129 => "Arcade - Platformer (Single Screen)",
		130 => "Arcade - Qix",
		131 => "Arcade - Search & Rescue",
		132 => "Arcade - Tetris",
		133 => "Arcade - Tron",
		134 => "Arcade - Worm/Snake",
		135 => "Board Game - Backgammon",
		136 => "Board Game - Chess",
		137 => "Board Game - Draughts/Checkers",
		138 => "Board Game - Kalaha",
		139 => "Board Game - Miscellaneous",
		140 => "Board Game - Monopoly",
		141 => "Board Game - Othello",
		142 => "Board Game - Reversi",
		143 => "Board Game - Scrabble",
		144 => "Brain - 4 Wins",
		145 => "Brain - Arcade",
		146 => "Brain - Crossword",
		147 => "Brain - Hangman",
		148 => "Brain - Mastermind",
		149 => "Brain - Memory",
		150 => "Brain - Minesweeper",
		151 => "Brain - Miscellaneous",
		152 => "Brain - Solitaire",
		153 => "Brain - Tic Tac Toe",
		154 => "Brain - Tile Removal",
		155 => "Brain - Towers of Hanoi",
		156 => "Cards - Baccarat",
		157 => "Cards - Blackjack",
		158 => "Cards - Bridge",
		159 => "Cards - Miscellaneous",
		160 => "Cards - Poker",
		161 => "Cards - Skat",
		162 => "Cards - Solitaire",
		163 => "Educational - Geography",
		164 => "Educational - Maths",
		165 => "Educational - Miscellaneous",
		166 => "Educational - Quiz",
		167 => "Educational - Spelling",
		168 => "Educational - Typing",
		169 => "Educational - Vocabulary/Language",
		170 => "Gambling - [uncategorized]",
		171 => "Gambling - Battleships",
		172 => "Gambling - Dice",
		173 => "Gambling - Miscellaneous",
		174 => "Gambling - Racing",
		175 => "Gambling - Yahtzee",
		176 => "Misc. - Operating System",
		177 => "Misc. - Undefinable",
		178 => "Misc. - Weird!",
		179 => "Racing - Cars",
		180 => "Racing - Formula One",
		181 => "Racing - Miscellaneous",
		182 => "Racing - Motorcycle",
		183 => "Racing - Overhead",
		184 => "Racing - Stay on Track",
		185 => "Shoot'em Up - Bomber",
		186 => "Shoot'em Up - Centipede",
		187 => "Shoot'em Up - Crosshair",
		188 => "Shoot'em Up - Defender",
		189 => "Shoot'em Up - D-Scrolling",
		190 => "Shoot'em Up - Duel",
		191 => "Shoot'em Up - Gauntlet",
		192 => "Shoot'em Up - H-Scrolling",
		193 => "Shoot'em Up - Isometric",
		194 => "Shoot'em Up - Miscellaneous",
		195 => "Shoot'em Up - Missile Command",
		196 => "Shoot'em Up - Multi-Scrolling",
		197 => "Shoot'em Up - Platformer",
		198 => "Shoot'em Up - Racing",
		199 => "Shoot'em Up - Scramble",
		200 => "Shoot'em Up - Space Invaders",
		201 => "Shoot'em Up - Uridium",
		202 => "Shoot'em Up - V-Scrolling",
		203 => "Simulation - Flight (Civil)",
		204 => "Simulation - Flight (Military)",
		205 => "Simulation - Marine",
		206 => "Simulation - Miscellaneous",
		207 => "Simulation - Space",
		208 => "Simulation - Tank",
		209 => "Simulation - Train",
		210 => "Sports - Athletics",
		211 => "Sports - Cricket",
		212 => "Sports - Bike",
		213 => "Sports - Football/Soccer (Arcade)",
		214 => "Sports - Football/Soccer (Manager)",
		215 => "Sports - Miscellaneous",
		216 => "Sports - Shooting",
		217 => "Sports - Skating",
		218 => "Sports - Squash",
		219 => "Sports - Table Tennis",
		220 => "Sports - Watersports",
		221 => "Strategy - Company",
		222 => "Strategy - Detective",
		223 => "Strategy - Life",
		224 => "Strategy - Miscellaneous",
		225 => "Strategy - Politics",
		226 => "Shoot'em Up - 3D",
		227 => "Adventure - Visual Novel",
		228 => "Adventure - Tactical RPG",
		229 => "Adventure - Survival",
		230 => "Shoot'em Up - Survival",
	),

	'ext_search_combos' => array(
		'scb_running' => 'cbox_yesno',
		'scb_multiplayer' => 'dropdownMultiplayer',
		'scb_trainer' => 'cbox_yesno',
		'scb_intro' => 'cbox_yesno',
		'scb_freeware' => 'cbox_yesno',
		'scb_usermod' => 'cbox_yesno',
		'scb_bugs' => 'cbox_yesno',
		'scb_netplay' => 'cbox_yesno',
	    'scb_dump_type' => 'dropdownDumpType',
	),

	'freeformSearchFields' => array(
		'NAME' => '[[name]]',
		'DEVELOPER' => '[[developer]]',
		'PUBLISHER' => '[[publisher]]',
		'PROGRAMMER' => '[[programmer]]',
		'MUSICAN' => '[[musican]]',
		'GRAPHICS' => '[[graphics]]',
		'YEAR' => '[[year]]',
		'INFO' => '[[info]]',
		'INFO_ID' => '[[info_id]]',
		'PATH' => '[[path]]',
		'ECCIDENT' => '[[eccident]]',
		'CRC32' => '[[crc32]]',
	),

	'freeformSearchOperators' => array(
		'AND' => '+',
		'' => '=',
		'OR' => '|',
	),

	'dropdownStateYesNo' => array(
		0 	=> '[[empty]]',
		1	=> '[[NO]]',
		2	=> '[[YES]]',
	),

	'dropdownMultiplayer' => array(
		0 	=> '[[empty]]',
		1	=> '[[NO]]',
		2	=> '[[2P]]',
		3	=> '[[3P]]',
		4	=> '[[4P]]',
	),

	'dropdownStateCount' => array(
		0 	=> '[[empty]]',
		1	=> '[[NO]]',
		2	=> '[[01]]',
		3	=> '[[02]]',
		4	=> '[[03]]',
		5	=> '[[04]]',
		6	=> '[[05]]',
		7	=> '[[06]]',
		8	=> '[[07]]',
		9	=> '[[08]]',
		10	=> '[[09]]',
		11	=> '[[10]]',
	),

	'dropdownStateTrainer' => array(
		0 	=> '[[empty]]',
		1	=> '[[NO]]',
		2	=> '[[YES]]',
	),

	'dropdownStorage' => array(
		0 => '[[empty]]',
		1 => '[[not_possible]]',
		2 => '[[not_battery]]',
		3 => '[[not_password_code]]',
		4 => '[[not_memory_card]]',
		5 => '[[on_harddrive]]',
	),

	'dropdownRegion' => array(
		0 => '[[empty]]',
		1 => '[[Asia]]',
		2 => '[[Brazil]]',
		3 => '[[Europe]]',
		4 => '[[Hispanic]]',
		5 => '[[Japan]]',
		6 => '[[USA]]',
		7 => '[[World]]',
		8 => '[[Australia]]',
		9 => '[[USA-Europe]]',
		10 => '[[USA-Japan]]',
	),

	# meta -> dropdownMedium
	'dropdownMediaType' => array(
		0 => 'unknown',
		1 => 'cd',
		2 => 'tape',
		3 => 'floppydisc',
		4 => 'cartridge',
		5 => 'card',
		6 => 'arcade_board',
	),

	'dropdownDumpType' => array(
		0 => 'unknown',
		1 => '[!]', // Verified Good Dump
		2 => '[a]', // Alternate
		3 => '[b]', // Bad Dump
		4 => '[t]', // Trained
		5 => '[f]', // Fixed
		6 => '[T]', // Translation
		7 => '[h]', // Hack
		8 => '[o]', // Overdump
		9 => '[p]', // Pirate
		10 => '[cr]', // [cr] Cracked
		11 => '[misc_fav]', // users favorite dump
		12 => '[misc_amiga_WHD]', // Amiga WHDLoad dump
		13 => '[misc_amiga_ADF]', // Amiga ADF dump
		14 => '[misc_amiga_IPF]', // Amiga IPF dump
		15 => '[misc_amiga_SPS]', // Amiga SPS dump
	),

	// Please also edit the file ecc-core\tools\MobyGamesImporter.list to match!
	'dropdownPerspective' => array(
		0 => 'unknown',
		1 => '1st-person',
		2 => '3rd-person',
		3 => 'Audio game',
		4 => 'Behind view',
		5 => 'Birds-eye view',
		6 => 'Side view',
		7 => 'Text-based / Spreadsheet',
		8 => 'Top-down',
	),

	// Please also edit the file ecc-core\tools\MobyGamesImporter.list to match!
	'dropdownVisual' => array(
		0 => 'unknown',
		1 => '2D scrolling',
		2 => 'Cinematic camera',
		3 => 'Fixed / Flip-screen',
		4 => 'Free-roaming camera',
		5 => 'Isometric',
	),

	'ratingUSK' => array(
		0 => 'unknown',
		1 => '0',
		2 => '6',
		3 => '12',
		4 => '16',
		5 => '18',
	),

	// europe
	'ratingPEGI' => array(
		0 => 'unknown',
		1 => '3',
		2 => '4',
		3 => '6',
		4 => '7',
		5 => '12',
		6 => '16',
		7 => '18',
	),

	// great britain
	'ratingBBFC' => array(
		0 => 'unknown',
		1 => '0',
		2 => '3',
		3 => '7',
		4 => '12',
		5 => '15',
		6 => '18',
	),

	// usa
	'ratingESRB' => array(
		0 => 'unknown',
		1 => 'eC', // (= early Childhood; ab 3 Jahren geeignet)
		2 => 'E', // (= Everyone; ab 6 Jahren geeignet)
		3 => 'E10+', // (= Everyone 10 and older; ab 10 Jahren geeignet)
		4 => 'T', // (= Teen; ab 13 Jahren geeignet)
		5 => 'M', // (= Mature; ab 17 Jahren geeignet)
		6 => 'AO', // (= Adults Only; ab 18 Jahren geeignet)
	),

	'eccHelpLocations' => array(
		'ECC_DOC_OFFLINE' => '/ecc-docs/index.html',
		'ECC_DOC_ONLINE' => 'https://github.com/PhoenixInteractiveNL/emuControlCenter/wiki',
		'ECC_WEBSITE' => 'https://github.com/PhoenixInteractiveNL/emuControlCenter/wiki',
		'ECC_FORUM' => 'http://eccforum.phoenixinteractive.nl/',
		'ECC_FACEBOOK' => 'https://www.facebook.com/emuControlCenter/',
		'EDC_WEBSITE' => 'https://github.com/PhoenixInteractiveNL/emuDownloadCenter/wiki',

		'ECC_EXE_START' => 'ecc.exe',
		'ECC_SCRIPT_EXTENSION' => '.eccscript',
		'LOG_DIR' => '/ecc-user-logs',

		'SCRIPT_ECCUPDATE' => 'ecc-core/tools/eccUpdate.au3',
		'SCRIPT_GTKTHEMESELECT' => 'ecc-core/tools/gtkThemeSelect.au3',
		'SCRIPT_ECCDIAGNOSTICS' => 'ecc-core/tools/eccDiagnostics.au3',
		'SCRIPT_DATFILEUPDATE' => 'ecc-core/tools/eccDatFileUpdater.au3',
		'SCRIPT_IMAGEINJECT' => 'ecc-core/tools/iccImageInject.au3',
		'SCRIPT_IMAGEPACKCENTER' => 'ecc-core/tools/eccImagePackCenter.au3',
		'SCRIPT_EMUDOWNLOADCENTER' => 'ecc-core/tools/emuDownloadCenter.au3',
		'SCRIPT_CREATESTARTMENUICONS' => 'ecc-core/tools/eccCreateStartmenuShotcuts.au3',
		'SCRIPT_KAMELEON' => 'ecc-core/tools/eccKameleonCode.au3',
		'SCRIPT_EMUMOVIES' => 'ecc-core/tools/emuMoviesDownloader.au3',
		'SCRIPT_3DGALLERY' => 'ecc-core/tools/3dGallery.au3',
		'SCRIPT_TRIGGER' => 'ecc-core/tools/eccTriggerScript.au3',
		'SCRIPT_VIDEOPLAYER' => 'ecc-core/tools/eccVideoPlayer.au3',
		'SCRIPT_MOBYGAMES' => 'ecc-core/tools/MobyGamesImporter.au3',
		'SCRIPT_GETCRC32' => 'ecc-core/tools/getCRC32.au3',
		'ECC_EXE_SCRIPT' => 'ecc-core/thirdparty/autoit/AutoIt3.exe',
		'ECC_EXE_SCRIPT_EDITOR' => 'ecc-core/thirdparty/notepad++/notepad++.exe',
		'ECC_EXE_HEX_EDITOR' => 'ecc-core/thirdparty/hxd/HxD32.exe',
		'ECC_EXE_DEV_GUI_GLADE' => 'ecc-core/php-gtk2/glade-3.exe',
		'ECC_EXE_DEV_GUI_KODA' => 'ecc-core/thirdparty/koda/fd.exe',
		'ECC_EXE_SQL_BROWSER' => 'ecc-core/thirdparty/sqlitebrowser/sqlitebrowser.exe',

	),

	'eccdb' => array (
		'META_ADD_URL' => '',
		'META_GET_URL' => '',
		'META_DATFILE_URL' => '',
		'GOOGLE_ROM_SEARCH' => 'http://www.google.com/search?q=',
	),
);
?>